/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

#ifndef IDENTOS_H
#define IDENTOS_H

#include <mini_api.h>
#include <typedefs.h>

typedef enum {
    OS_UNIX,
    OS_DOS,
    OS_WIN3X,
    OS_WIN32,       /* only returned in *pCompiledFor */ 
    OS_WIN95,
    OS_WINNT,
    OS_UNKNOWN
} B_OS_VERSION;

/* Returns OS and other details as required...
   send null's if you don't want it 
*/

#ifdef __cplusplus
extern "C" {
#endif


B_OS_VERSION EXPORT GetOsVersion( 
                        char szVersion[80],
                        B_OS_VERSION * pCompiledFor
                        );

/* Only returns the current OS */

B_OS_VERSION EXPORT GetOsVersionShort();


#ifdef __cplusplus
}
#endif


#endif  /* IDENTOS_H */
